//
//  WXKWindowController.m
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/08/23.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import "WXKWindowController.h"
#import "WXKPasswordWindowController.h"
#import "WXKError.h"


NSString	*WXKToolbarReceiveItemIdentifier			= @"Receive Item Identifier";
NSString	*WXKToolbarSendItemIdentifier				= @"Send Item Identifier";
NSString	*WXKToolbarAddressUtilityItemIdentifier		= @"Address Utility Item Identifier";
NSString	*WXKToolbarBookmarkUtilityItemIdentifier	= @"Bookmark Utility Item Identifier";
NSString	*WXKToolbarFileUtilityItemIdentifier		= @"File Utility Item Identifier";
NSString	*WXKToolbarMailUtilityItemIdentifier		= @"Mail Utility Item Identifier";

NSString	*kWXKForceToAskPasswordKey					= @"kWXKForceToAskPasswordKey";


@interface WXKWindowController (Private)

- (void)receiveAlertDidEnd:(NSAlert *)alert returnCode:(int)returnCode contextInfo:(void *)contextInfo;
- (void)sendAlertDidEnd:(NSAlert *)alert returnCode:(int)returnCode contextInfo:(void *)contextInfo;

@end


#pragma mark -


@implementation WXKWindowController


#pragma mark override superclass

- (void)windowDidLoad
{
	[super windowDidLoad];
	
	[[self window] setExcludedFromWindowsMenu:YES];
}


#pragma mark Action methods and their didEndSelectors

- (IBAction)receive:(id)sender
{
//	[[self managedObjectContext] commitEditing];
	[[self managedObjectContext] processPendingChanges];
	
	NSError *error;
	if ([[self managedObjectContext] save:&error] == NO) {
		
		[self presentError:error
			modalForWindow:[self window]
				  delegate:nil
		didPresentSelector:NULL
			   contextInfo:NULL];
		return;
	}
	
	if ([[itemsController allObjects] count] > 0) {
		
		NSAlert *alert = [[[NSAlert alloc] init] autorelease];
		[alert addButtonWithTitle:NSLocalizedString(@"Receive", @"receiveSheet.firstButton")];
		[alert addButtonWithTitle:NSLocalizedString(@"Cancel", @"receiveSheet.secondButton")];
		[alert setMessageText:[NSString stringWithFormat:NSLocalizedString(@"Are you sure you want to overwrite the %@ on this computer with the data received from your Kyopon?", @"receiveSheet.message"), [self localizedPluralItemName]]];
		[alert setInformativeText:NSLocalizedString(@"Any changes you've made on this computer will be lost.", @"receiveSheet.information")];
		[alert setAlertStyle:NSInformationalAlertStyle];
//		[alert setHelpAnchor:@"ahkabhlp22"];
//		[alert setShowsHelp:YES];
		
		[alert beginSheetModalForWindow:[self window]
						  modalDelegate:self
						 didEndSelector:@selector(receiveAlertDidEnd:returnCode:contextInfo:)
							contextInfo:NULL];
	} else {
		[self receiveAlertDidEnd:nil returnCode:NSAlertFirstButtonReturn contextInfo:NULL];
	}
}

- (void)receiveAlertDidEnd:(NSAlert *)alert returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
	if (returnCode == NSAlertFirstButtonReturn) {
	
		[[alert window] orderOut:nil];
		[[[self window] attachedSheet] orderOut:nil];
		
		BOOL forceToAskUserForPassword = NO;
		if (contextInfo && [(id)contextInfo isKindOfClass:[NSDictionary class]]) {
			forceToAskUserForPassword = [[(NSDictionary *)contextInfo objectForKey:kWXKForceToAskPasswordKey] boolValue];
			[(id)contextInfo release];
		}
		
		WXKPasswordWindowController *passwordController = [WXKPasswordWindowController sharedWindowController];
		
		// Get a password if it is stored in Keychains or formerly entered by user.
		// (If forceToAskUserForPassword == YES, skip this step.)
		NSString *password = (forceToAskUserForPassword ? nil : [passwordController password]);
		
		// If password is not found in Keychains or former entry, ask user to enter the password.
		if (password == nil && [passwordController runModal] == NSAlertFirstButtonReturn) {
			password = [passwordController password];
		}
		
		if (password != nil) {
			
			NSError *error;
			
			// If password is obtained, begin to communicate with Kyopon.
			if ([self receiveWithPassword:password error:&error] == NO) {
				// when received error
				[self presentError:error
					modalForWindow:[self window]
						  delegate:self
				didPresentSelector:@selector(didPresentReceiveErrorWithRecovery:contextInfo:)
					   contextInfo:NULL];
			}
		}
	}
}

- (void)didPresentReceiveErrorWithRecovery:(BOOL)didRecover contextInfo:(void *)contextInfo
{
//	NSString *log = (didRecover ? @"RECOVERY SUCCEEDED" : @"RECOVERY FAILED");
//	NSLog(@"%@", log);
}


- (IBAction)send:(id)sender
{
	[[self managedObjectContext] commitEditing];
	[[self managedObjectContext] processPendingChanges];
	
	// Before sending, save the managed object context in order to check validation errors.
	NSError *error;
	if ([[self managedObjectContext] save:&error] == NO) {
		[self presentError:error
			modalForWindow:[self window]
				  delegate:nil
		didPresentSelector:NULL
			   contextInfo:NULL];
		return;
	}
	
	NSAlert *alert = [[[NSAlert alloc] init] autorelease];
	[alert addButtonWithTitle:NSLocalizedString(@"Send", @"sendSheet.firstButton")];
	[alert addButtonWithTitle:NSLocalizedString(@"Cancel", @"sendSheet.secondButton")];
	[alert setMessageText:[NSString stringWithFormat:NSLocalizedString(@"Are you sure you want to overwrite the %@ on your Kyopon with the data send from this computer?", @"sendSheet.message"), [self localizedPluralItemName]]];
	[alert setInformativeText:NSLocalizedString(@"Any changes you've made on your Kyopon will be lost.", @"sendBookmrksSheet.information")];
	[alert setAlertStyle:NSInformationalAlertStyle];
//	[alert setHelpAnchor:@"ahkabhlp21"];
//	[alert setShowsHelp:YES];
	
	[alert beginSheetModalForWindow:[self window]
					  modalDelegate:self
					 didEndSelector:@selector(sendAlertDidEnd:returnCode:contextInfo:)
						contextInfo:NULL];
}

- (void)sendAlertDidEnd:(NSAlert *)alert returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
	if (returnCode == NSAlertFirstButtonReturn) {
	
		[[alert window] orderOut:nil];
		[[[self window] attachedSheet] orderOut:nil];
		
		BOOL forceToAskUserForPassword = NO;
		if (contextInfo && [(id)contextInfo isKindOfClass:[NSDictionary class]]) {
			forceToAskUserForPassword = [[(NSDictionary *)contextInfo objectForKey:kWXKForceToAskPasswordKey] boolValue];
			[(id)contextInfo release];
		}
		
		WXKPasswordWindowController *passwordController = [WXKPasswordWindowController sharedWindowController];
		
		// Get a password if it is stored in Keychains or formerly entered by user.
		// (If forceToAskUserForPassword == YES, skip this step.)
		NSString *password = (forceToAskUserForPassword ? nil : [passwordController password]);
		
		// If password is not found in Keychains or former entry, ask user to enter the password.
		if (password == nil && [passwordController runModal] == NSAlertFirstButtonReturn) {
			password = [passwordController password];
		}
		
		if (password != nil) {
			
			NSError *error;
			
			// If password is obtained, begin to communicate with Kyopon.
			if ([self sendWithPassword:password error:&error] == NO) {
				
				// when received error
				[self presentError:error
					modalForWindow:[self window]
						  delegate:self
				didPresentSelector:@selector(didPresentSendErrorWithRecovery:contextInfo:)
					   contextInfo:NULL];
			}
		}
	}
}

- (void)didPresentSendErrorWithRecovery:(BOOL)didRecover contextInfo:(void *)contextInfo
{
//	NSString *log = (didRecover ? @"RECOVERY SUCCEEDED" : @"RECOVERY FAILED");
//	NSLog(@"%@", log);
}


#pragma mark NSErrorRecoveryAttempting informal protocol

//- (BOOL)attemptRecoveryFromError:(NSError *)error optionIndex:(unsigned int)recoveryOptionIndex

- (void)attemptRecoveryFromError:(NSError *)error optionIndex:(unsigned int)recoveryOptionIndex delegate:(id)delegate didRecoverSelector:(SEL)didRecoverSelector contextInfo:(void *)contextInfo
{
	BOOL success = NO;
	
	if (delegate == self && didRecoverSelector == @selector(didPresentReceiveErrorWithRecovery:contextInfo:)) {
		if (recoveryOptionIndex == 0) {
			// When recovery requested...
			
			switch ([error code]) {
				case WXKPhoneIncorrectPasswordError:
				case WXKPhoneInapplicablePasswordStringLengthError:
				case WXKPhoneInapplicablePasswordStringEncodingError:
					[self receiveAlertDidEnd:nil 
								  returnCode:NSAlertFirstButtonReturn
								 contextInfo:[[NSDictionary alloc] initWithObjectsAndKeys:[NSNumber numberWithBool:YES],
									 kWXKForceToAskPasswordKey,
									 nil]];
					success = YES;
					break;
				default:
					[self receiveAlertDidEnd:nil 
								  returnCode:NSAlertFirstButtonReturn
								 contextInfo:NULL];
					success = YES;
					break;
			}
		}
		[self didPresentReceiveErrorWithRecovery:success contextInfo:NULL];
		return;
		
	} else if (delegate == self && didRecoverSelector == @selector(didPresentSendErrorWithRecovery:contextInfo:)) {
		if (recoveryOptionIndex == 0) {
			// When recovery requested...
			
			switch ([error code]) {
				case WXKPhoneIncorrectPasswordError:
				case WXKPhoneInapplicablePasswordStringLengthError:
				case WXKPhoneInapplicablePasswordStringEncodingError:
					[self sendAlertDidEnd:nil 
							   returnCode:NSAlertFirstButtonReturn
							  contextInfo:[[NSDictionary alloc] initWithObjectsAndKeys:[NSNumber numberWithBool:YES],
								  kWXKForceToAskPasswordKey,
								  nil]];
					success = YES;
					break;
				default:
					[self sendAlertDidEnd:nil 
							   returnCode:NSAlertFirstButtonReturn
							  contextInfo:NULL];
					success = YES;
					break;
			}
		}
		[self didPresentSendErrorWithRecovery:success contextInfo:NULL];
		return;
	}
	
	NSInvocation *invoke = [[NSInvocation alloc] init];
	[invoke setSelector:didRecoverSelector];
	[invoke setArgument:(void *)&success atIndex:2];
	[invoke setArgument:NULL atIndex:3];
	[invoke invokeWithTarget:delegate];
	[invoke autorelease];
}

#pragma mark override superclass (NSResponder)

- (NSError *)willPresentError:(NSError *)error
{
	if ([[error domain] isEqualToString:WXKErrorDomain]) {
		switch ([error code]) {
			case WXKPhoneUserCancelledError:
				break;
			case WXKPhoneIncorrectPasswordError:
			case WXKPhoneInapplicablePasswordStringLengthError:
			case WXKPhoneInapplicablePasswordStringEncodingError:
			{
				NSMutableDictionary *newUserInfo = [NSMutableDictionary dictionary];
				if ([error userInfo] != nil) {
					[newUserInfo setDictionary:[error userInfo]];
				}
				NSString *recoverySuggestion = NSLocalizedString(@"Enter security code and try again?", @"incorrectPasswordError.recoverySuggestion");
				[newUserInfo setObject:recoverySuggestion forKey:NSLocalizedRecoverySuggestionErrorKey];
				[newUserInfo setObject:self forKey:NSRecoveryAttempterErrorKey];
				[newUserInfo setObject:[NSArray arrayWithObjects:NSLocalizedString(@"Try Again", @""), NSLocalizedString(@"Cancel", @""), nil] forKey:NSLocalizedRecoveryOptionsErrorKey];
				return [NSError errorWithDomain:[error domain]
											   code:[error code] 
										   userInfo:newUserInfo];
			}
			default:
			{
				NSMutableDictionary *newUserInfo = [NSMutableDictionary dictionary];
				if ([error userInfo] != nil) {
					[newUserInfo setDictionary:[error userInfo]];
				}
				NSString *recoverySuggestion = NSLocalizedString(@"Make sure that the cable is connected and that your cellphone is on stanby with its top screen displayed. Try again?", @"otherError.recoverySuggestion");
				[newUserInfo setObject:recoverySuggestion forKey:NSLocalizedRecoverySuggestionErrorKey];
				[newUserInfo setObject:self forKey:NSRecoveryAttempterErrorKey];
				[newUserInfo setObject:[NSArray arrayWithObjects:NSLocalizedString(@"Try Again", @""), NSLocalizedString(@"Cancel", @""), nil] forKey:NSLocalizedRecoveryOptionsErrorKey];
				return [NSError errorWithDomain:[error domain]
											   code:[error code] 
										   userInfo:newUserInfo];
			}
		}
	}
	return [super willPresentError:error];
}


#pragma mark NSToolbar delegate

- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
{
	NSToolbarItem *toolbarItem = nil;
	
	if ([itemIdentifier isEqual:WXKToolbarReceiveItemIdentifier]) {
		
		// Receive
		toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] autorelease];
		[toolbarItem setLabel:NSLocalizedString(@"Receive", @"toolbar.receive.label")];
		[toolbarItem setPaletteLabel:NSLocalizedString(@"Receive from Kyopon", @"toolbar.receive.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedString(@"Receive data from Kyopon.", @"toolbar.receive.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarReceiveIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(receive:)];
	
	} else if ([itemIdentifier isEqual:WXKToolbarSendItemIdentifier]) {
		
		// Send
		toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] autorelease];
		[toolbarItem setLabel:NSLocalizedString(@"Send", @"toolbar.send.label")];
		[toolbarItem setPaletteLabel:NSLocalizedString(@"Send to Kyopon", @"toolbar.send.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedString(@"Send data to Kyopon.", @"toolbar.send.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarSendIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(send:)];
	
	} else if ([itemIdentifier isEqual:WXKToolbarAddressUtilityItemIdentifier]) {
		
		// Launch Addres Utility
		toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] autorelease];
		[toolbarItem setLabel:NSLocalizedString(@"Address Utility", @"toolbarItem.addressUtility.label")];
		[toolbarItem setPaletteLabel:NSLocalizedString(@"Launch Address Utility", @"toolbarItem.addressUtility.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedString(@"Launch Kyopon Address Utility.", @"toolbarItem.addressUtility.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarAddressUtilityIcon.tiff"]];
		[toolbarItem setTarget:nil];
		[toolbarItem setAction:@selector(launchAddressUtility:)];
	
	} else if ([itemIdentifier isEqual:WXKToolbarBookmarkUtilityItemIdentifier]) {
		
		// Launch Bookmark Utility
		toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] autorelease];
		[toolbarItem setLabel:NSLocalizedString(@"Bookmark Utility", @"toolbarItem.bookmarkUtility.label")];
		[toolbarItem setPaletteLabel:NSLocalizedString(@"Launch Bookmark Utility", @"toolbarItem.bookmarkUtility.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedString(@"Launch Kyopon Bookmark Utility.", @"toolbarItem.bookmarkUtility.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarBookmarkUtilityIcon.tiff"]];
		[toolbarItem setTarget:nil];
		[toolbarItem setAction:@selector(launchBookmarkUtility:)];
	
	} else if ([itemIdentifier isEqual:WXKToolbarFileUtilityItemIdentifier]) {
		
		// Launch File Utility
		toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] autorelease];
		[toolbarItem setLabel:NSLocalizedString(@"File Utility", @"toolbarItem.fileUtility.label")];
		[toolbarItem setPaletteLabel:NSLocalizedString(@"Launch File Utility", @"toolbarItem.fileUtility.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedString(@"Launch Kyopon File Utility.", @"toolbarItem.fileUtility.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarFileUtilityIcon.tiff"]];
		[toolbarItem setTarget:nil];
		[toolbarItem setAction:@selector(launchFileUtility:)];
	
	} else if ([itemIdentifier isEqual:WXKToolbarMailUtilityItemIdentifier]) {
		
		// Launch Mail Utility
		toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] autorelease];
		[toolbarItem setLabel:NSLocalizedString(@"Mail Utility", @"toolbar.mailUtility.label")];
		[toolbarItem setPaletteLabel:NSLocalizedString(@"Launch Mail Utility", @"toolbar.mailUtility.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedString(@"Launch Kyopon Mail Utility.", @"toolbar.mailUtility.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarMailUtilityIcon.tiff"]];
		[toolbarItem setTarget:nil];
		[toolbarItem setAction:@selector(launchMailUtility:)];
	
	} else if ([super respondsToSelector:@selector(toolbar:itemForItemIdentifier:willBeInsertedIntoToolbar:)]) {
	
		toolbarItem = [super toolbar:toolbar 
			   itemForItemIdentifier:itemIdentifier 
		   willBeInsertedIntoToolbar:flag];
	
	} else {
		toolbarItem = nil;
	}
	
	return toolbarItem;
}

//- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar
//- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
//
#pragma mark implementation of NSToolbarItemValidation
- (BOOL)validateToolbarItem:(NSToolbarItem *)theItem
{
//	// Prevent removing folders. (Superclass FJDItemsInFolderWindowController allows to add and remove folder)
//	if ([theItem action] == @selector(delete:)) {
//		if ([[self window] firstResponder] == foldersTableView) {
//			return NO;
//		}
//	}
	
	if ([super respondsToSelector:@selector(validateToolbarItem:)]) {
		return [super validateToolbarItem:theItem];
	}
	
	return YES;
}

#pragma mark NSMenuValidation informal protocol
- (BOOL)validateMenuItem:(id <NSMenuItem>)theItem
{
//	// Prevent removing folders. (Superclass FJDItemsInFolderWindowController allows to add and remove folder)
//	if ([theItem action] == @selector(delete:)) {
//		if ([[self window] firstResponder] == foldersTableView) {
//			return NO;
//		}
//	}
	
	if ([theItem action] == @selector(showWindow:)) {
		[theItem setState:([[self window] isKeyWindow] ? NSOnState : NSOffState)];
		return YES;
		
	} else if ([super respondsToSelector:@selector(validateMenuItem:)]) {
		return [super validateMenuItem:theItem];
	}
	
	return YES;
}

@end
